<?php

class Vesti {
// Konstante
    const ime_hosta = 'localhost';
    const korisnik = 'root';
    const sifra = '';
    const ime_baze = "komentari";

    // Atributi
    private $dbh; // konekcija prema bazi

    // Metode
    // Zadatak konstruktora je otvaranje konekcije prema bazi
    function  __construct() {
        try {
            $konekcioni_string="mysql:host=".self::ime_hosta.";dbname=".self::ime_baze;
            $this->dbh = new PDO($konekcioni_string, self::korisnik, self::sifra);
        }
        catch(PDOException $e) {
            echo "GRESKA: ";
            echo $e->getMessage();
        }
    }

    // Zadatak destruktora je zatvaranje konekcije prema bazi
    function  __destruct() {
        $this->dbh = null;
    }

    
    public function stampaj_tabelu_vesti() {
        try {
            $sql = "SELECT vest_id, title, description FROM vesti";

            $pdo_izraz = $this->dbh->query($sql);
            $niz = $pdo_izraz->fetchALL(PDO::FETCH_ASSOC);

            foreach($niz as $vest) {
                echo "<a href='prikaz.php?vestId=".$vest['vest_id']."'><h3>".$vest['title']."</h3></a>";
                echo implode(' ', array_slice(explode(' ', $vest['description']), 0, 10))."...";
                
                //echo "<td>".$knjiga['godina']."</td>";
                //echo "<td><input type='button' id='".$knjiga['id']."' value='brisi' onclick='brisi(this.id)'></td>";
                //echo "<td><input type='button' id='".$knjiga['id']."' value='izmeni' onclick='izmeni(this.id)'></td></tr>";
            }
        }
        catch(PDOException $e) {
            echo "GRESKA: ";
            echo $e->getMessage();
        }
    }
    
    public function stampaj_komentare($vest_id) {
        try {
            $sql = "SELECT * FROM komentari WHERE vest_id=".$vest_id;
            $pdo_izraz = $this->dbh->query($sql);
            $niz = $pdo_izraz->fetchALL(PDO::FETCH_ASSOC);

            foreach($niz as $komentar) {
                echo "<div class='transbox'><p>".$komentar['tekst']."</p></div>";
                //echo $vest['description'];
                //echo "<br />";
            }
            echo '<form action="" method="get">';
               echo '<input type="hidden" value="'.$vest_id.'" name="vestId">';
               echo "<textarea cols='70' rows='10' id='comment' name='comment'></textarea><br />";
               echo '<input type="submit" value="Dodaj komentar">';
            echo '</form>';
        }
        catch(PDOException $e) {
            echo "GRESKA: ";
            echo $e->getMessage();
        }
    }

    public function dodaj($vestId, $komentar){
        try {
            $sql = "INSERT INTO komentari_check(vest_id,tekst)";
            $sql.= "VALUES ('$vestId', '$komentar')";
            $pdo_izraz = $this->dbh->exec($sql);
            return true;
        }
        catch(PDOException $e) {
            echo "GRESKA: ";
            echo $e->getMessage();
            return false;
        }
    }
    
    public function svi_komentari_check() {
        try {
            $sql = "SELECT * FROM komentari_check";

            $pdo_izraz = $this->dbh->query($sql);
            $niz = $pdo_izraz->fetchALL(PDO::FETCH_ASSOC);

            return $niz;
        }
        catch(PDOException $e) {
            echo "GRESKA: ";
            echo $e->getMessage();
        }
    }

     
    public function podaci_za_vest($id) {
        try {
            $sql = "SELECT * FROM vesti WHERE vest_id=$id";
            $pdo_izraz = $this->dbh->query($sql);
            $obj = $pdo_izraz->fetch(PDO::FETCH_ASSOC);
            return $obj;
        }
        catch(PDOException $e) {
            echo "GRESKA: ";
            echo $e->getMessage();
        }
    }
    
    public function podaci_za_komentar($id) {
        try {
            $sql = "SELECT * FROM komentari_check WHERE comm_id=$id";
            $pdo_izraz = $this->dbh->query($sql);
            $obj = $pdo_izraz->fetch(PDO::FETCH_ASSOC);
            return $obj;
        }
        catch(PDOException $e) {
            echo "GRESKA: ";
            echo $e->getMessage();
        }
    }

 
    public function izvrsi_transakciju($id) {
        try {
            /* Pocni transakciju, ovim se iskljucuje autocommit */
            $sql = "SELECT * FROM komentari_check WHERE comm_id=$id";
            $pdo_izraz = $this->dbh->query($sql);
            $obj = $pdo_izraz->fetch(PDO::FETCH_ASSOC);
            //echo $obj['vest_id'];
            //echo $obj['tekst'];
            
            $this->dbh->beginTransaction();
            /* Izmeni podatke u bazi */       
            $this->dbh->exec("INSERT INTO komentari(vest_id,tekst,positive,negative) VALUES (".$obj['vest_id'].",'".$obj['tekst']."',0,0)");
            $this->dbh->exec("DELETE FROM komentari_check WHERE comm_id=$id");
            $this->dbh->commit();
            /* Konekcija se vraca u autocommit mod */
            //echo $obj['vest_id'];
        }
        catch(PDOException $e) {
            echo "GRESKA: ";
            echo $e->getMessage();
        }
    }


} 

?>


